<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
  <xsl:param name="xslResourceDirectory" select="cif:xslResourceDirectory"/>
  <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>

    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
        	<link rel="stylesheet" type="text/css" href="{$xslResourceDirectory}/engtheme.css"/>
                <title lang="en">MoDOT Horizontal and Vertical Alignment Review Report</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Geometry for Electronic Deliverables</h2>
                            </center>
							<xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Project:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Description:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">File Name:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                    </tbody>
                                </table>
							</xsl:for-each>
                            <xsl:for-each select="GeometryProject">
                            <hr/>
                                <table  class="margin" cellpadding="2" cellspacing="0" width="80%">
                                    <colgroup span="5">
                                        <col width="18%"/>
                                        <col width="13%"/>
                                        <col width="25%"/>
                                        <col width="22%"/>
                                        <col width="22%"/>
                                    </colgroup>
                                    <xsl:for-each select="HorizontalAlignment">
                                        <tbody>
                                            <tr>
                                                <th align="right" colspan="2" lang="en"><br/>----Horizontal Alignment:&#xa0;</th>
                                                <td align="left" colspan="3" valign="bottom"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th colspan="2"/>
                                                <th class="underline" align="right" lang="en">Station</th>
                                            </tr>
                                            <xsl:apply-templates mode="horizontalPOB"/>
                                            <xsl:apply-templates mode="horizontalPOE"/>
                                            <xsl:for-each select="VerticalAlignment">
                                                <tr>
                                                    <th align="right" colspan="2" lang="en">Vertical Alignment:&#xa0;</th>
                                                    <td align="left" colspan="3" valign="bottom"><xsl:value-of select="@name"/></td>
                                                </tr><br/> 
                                                <xsl:apply-templates mode="vertical"/>
                                            </xsl:for-each>
                                        </tbody>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="HorizontalLine[Start/@pointType != 'PI']" mode="horizontalPOB">
     <xsl:choose>
      <xsl:when test="Start/@pointType = 'POB'">
        <tr>
          <td align="right">
            <xsl:value-of select="cif:pointType(string(Start/@pointType))"/>
          </td>
          <td align="right">
            ( Beginning Point #<xsl:value-of select="Start/@name"/> )
          </td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
          </td>
         </tr>
      </xsl:when>
	 </xsl:choose>
    </xsl:template>
 <xsl:template match="HorizontalLine[End/@pointType != 'PI']" mode="horizontalPOE">
     <xsl:choose>
      <xsl:when test="End/@pointType = 'POE'">
        <tr>
          <td align="right">
            <xsl:value-of select="cif:pointType(string(End/@pointType))"/>
          </td>
          <td align="right">
            ( Ending Point #<xsl:value-of select="End/@name"/> )
          </td>
          <td align="right">
            <xsl:value-of select="cif:stationFormat(number(End/station/@externalStation), string(Start/station/@externalStationName))"/>
          </td>
        </tr>
      </xsl:when>
	 </xsl:choose>
    </xsl:template>

    <xsl:template match="VerticalLine" mode="vertical">
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
                You must select at least one Civil horizontal geometry element to get Horizontal results from this report.
            </p>
            <p class="normal1" lang="en">
                You must have an Active Profile comprised of at least one Civil vertical geometry element for a complete report.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
